<?php if ( ! defined( 'BASEL_THEME_DIR' ) ) {
	exit( 'No direct script access allowed' );
}
use XTS\Options;

/**
 * Custom CSS section.
 */
Options::add_section(
	array(
		'id'       => 'custom_css',
		'name'     => esc_html__( 'Custom CSS', 'basel' ),
		'priority' => 120,
		'icon'     => 'dashicons dashicons-buddicons-topics',
	)
);


Options::add_field(
	array(
		'id'       => 'custom_css',
		'name'     => esc_html__( 'Global Custom CSS', 'basel' ),
		'type'     => 'editor',
		'language' => 'css',
		'section'  => 'custom_css',
		'priority' => 10,
	)
);

Options::add_field(
	array(
		'id'       => 'css_desktop',
		'name'     => esc_html__( 'Custom CSS for desktop', 'basel' ),
		'type'     => 'editor',
		'language' => 'css',
		'section'  => 'custom_css',
		'priority' => 20,

	)
);

Options::add_field(
	array(
		'id'       => 'css_tablet',
		'name'     => esc_html__( 'Custom CSS for tablet', 'basel' ),
		'type'     => 'editor',
		'language' => 'css',
		'section'  => 'custom_css',
		'priority' => 30,

	)
);

Options::add_field(
	array(
		'id'       => 'css_wide_mobile',
		'name'     => esc_html__( 'Custom CSS for mobile landscape', 'basel' ),
		'type'     => 'editor',
		'language' => 'css',
		'section'  => 'custom_css',
		'priority' => 40,

	)
);

Options::add_field(
	array(
		'id'       => 'css_mobile',
		'name'     => esc_html__( 'Custom CSS for mobile', 'basel' ),
		'type'     => 'editor',
		'language' => 'css',
		'section'  => 'custom_css',
		'priority' => 50,
	)
);

Options::add_field(
	array(
		'id'       => 'css_backend',
		'name'     => esc_html__( 'Custom CSS for admin dashboard', 'basel' ),
		'type'     => 'editor',
		'language' => 'css',
		'section'  => 'custom_css',
		'priority' => 60,
	)
);
